(function($){
    'use strict';
	console.log(JSON.stringify(ZoomMtg.checkSystemRequirements()));

    ZoomMtg.preLoadWasm();
    ZoomMtg.prepareJssdk();
    var API_KEY = stm_zoom_settings.api_key;

    console.log(stm_zoom_settings);
    var API_SECRET = stm_zoom_settings.api_secret;
    var meetingId = stm_zoom_settings.meeting_id;
    var meetingPwd = stm_zoom_settings.password;
    var stmUserName = stm_zoom_settings.username;
    var homeUrl = stm_zoom_settings.home_url;
    testTool = window.testTool;

    $('.join_in_menu').on('click', function(e){
        e.preventDefault();
        $('#zmmtg-root').addClass('active');
        var meetConfig = {
            apiKey: API_KEY,
            apiSecret: API_SECRET,
            meetingNumber: parseInt(meetingId),
            userName: stmUserName,
            passWord: meetingPwd,
            leaveUrl: homeUrl,
            role: 0
        };


        var signature = ZoomMtg.generateSignature({
            meetingNumber: meetConfig.meetingNumber,
            apiKey: meetConfig.apiKey,
            apiSecret: meetConfig.apiSecret,
            role: meetConfig.role,
            success: function(res){
                console.log(res.result);
            }
        });

        ZoomMtg.init({
            leaveUrl: meetConfig.leaveUrl,
            isSupportAV: true,
            success: function () {
                ZoomMtg.join(
                    {
                        meetingNumber: meetConfig.meetingNumber,
                        userName: meetConfig.userName,
                        signature: signature,
                        apiKey: meetConfig.apiKey,
                        passWord: meetConfig.passWord,
                        success: function(res){
                            console.log('join meeting success');
                        },
                        error: function(res) {
                            console.log(res);
                        }
                    }
                );
            },
            error: function(res) {
                console.log(res);
            }
        });

    });

    $(document).ready(function () {
        $(document).on('click', '.full-screen-widget', function () {
            $('body').toggleClass('full-screen');
        });
        var esc = $.Event("keydown", { keyCode: 27 });
        $(document).trigger(esc);

        $( document ).keyup(function( e ){

            if (e.keyCode == 27) {
                $('body').removeClass('full-screen');
            }
        });

    })


})(jQuery);
