<?php
add_action( 'vc_after_init', 'stm_zoom_meeting' );

function stm_zoom_meeting()
{
    vc_map( array(
        'name' => esc_html__( 'STM Zoom Meeting', 'eroom-zoom-meetings-webinar' ),
        'base' => 'stm_zoom_meeting',
        'icon' => 'fas fa-video',
        'html_template' => STM_ZOOM_PATH . '/vc/templates/stm_zoom_meeting.php',
        'category' => array(
            esc_html__( 'Content', 'eroom-zoom-meetings-webinar' ),
        ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => __( 'Meeting', 'eroom-zoom-meetings-webinar' ),
                'param_name' => 'meeting_id',
                'value' => array_flip( get_meetings() )
            )
        )
    ) );
}

if( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Stm_Zoom_Meeting extends WPBakeryShortCode
    {
    }
}