<?php
new STM_ZOOM;

class STM_ZOOM
{
    function __construct()
    {
        add_action( 'init', array( $this, 'register_post_type' ), 10 );

        add_action( 'admin_menu', function() {
            add_menu_page( 'Zoom', 'Zoom', 'manage_options', 'stm_zoom', 'admin_pages', 'dashicons-video-alt2', 40 );
            self::admin_submenu_pages();
        }, 100 );

        if( is_admin() ) {
            self::admin_settings_page();
            self::metaboxes();
            add_filter( 'stm_wpcfto_autocomplete_stm_alternative_hosts', array( $this, 'get_autocomplete_users_options' ), 100 );
        }

        add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue' ) );

        add_action( 'wp_enqueue_scripts', array( $this, 'frontend_enqueue' ) );

        add_action( 'save_post', array( $this, 'update_meeting' ), 10 );

        add_action( 'admin_head', array( $this, 'admin_head' ) );

        add_action( 'wp_head', array( $this, 'head' ) );

        add_shortcode( 'stm_zoom_conference', array( $this, 'add_shortcode' ) );

        add_action( 'add_meta_boxes', array( $this, 'stm_zoom_add_custom_box' ) );

    }

    static function stm_zoom_add_custom_box()
    {
        $screens = array( 'stm-zoom' );
        add_meta_box( 'stm_zoom_info', 'Zoom meeting info', 'STM_ZOOM::meeting_info', $screens, 'side', 'high' );
    }

    public static function meeting_info($post, $meta)
    {
        $meeting_data = get_post_meta($post->ID, 'stm_zoom_data', true);
        if(!empty($meeting_data) && !empty($meeting_data['id'])){
            echo '<p>';
            echo esc_html__('Meeting shortcode ', 'eroom-zoom-meetings-webinar');
            echo '</p><p>';
            echo '<b>[stm_zoom_conference post_id="' . $post->ID . '"]</b>';
            echo '</p>';
        }
    }

    static function admin_enqueue()
    {
        wp_enqueue_style( 'stm_zoom_admin', STM_ZOOM_URL . '/assets/css/admin/main.css', false, '1.0.0' );
    }

    static function frontend_enqueue()
    {
        wp_enqueue_script( 'stm_jquery.countdown', STM_ZOOM_URL . '/assets/js/frontend/jquery.countdown.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'stm_zoom_main', STM_ZOOM_URL . '/assets/js/frontend/main.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_style( 'stm_zoom_main', STM_ZOOM_URL . '/assets/css/frontend/main.css', false, '1.0.0' );
        wp_enqueue_style('linear', STM_ZOOM_URL . '/wp-custom-fields-theme-options/assets/linearicons/linear.css', array(), '1.0.0');
    }

    static function admin_head()
    {
        ?>
        <script type="text/javascript">
            var stm_zoom_ajaxurl = '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>';
        </script>

        <?php
    }

    static function head()
    {
        ?>
        <script>
            var daysStr = '<?php esc_html_e( 'Days', 'eroom-zoom-meetings-webinar' ); ?>';
            var hoursStr = '<?php esc_html_e( 'Hours', 'eroom-zoom-meetings-webinar' ); ?>';
            var minutesStr = '<?php esc_html_e( 'Minutes', 'eroom-zoom-meetings-webinar' ); ?>';
            var secondsStr = '<?php esc_html_e( 'Seconds', 'eroom-zoom-meetings-webinar' ); ?>';
        </script>

        <?php
    }

    static function add_shortcode( $atts )
    {
        $atts = shortcode_atts( array(
            'post_id' => ''
        ), $atts );
        $content = '';
        if(!empty($atts['post_id'])){
            $content = self::add_zoom_content($atts['post_id']);
        }
        return $content;
    }

    static public function add_zoom_content($post_id){
        $content = '';
        if( !empty( $post_id ) ) {
            $post_id = intval( $post_id );
            $meeting_data = self::meeting_time_data($post_id);
            if(!empty($meeting_data) && !empty($meeting_data['meeting_start']) && !empty($meeting_data['meeting_date'])){
                $meeting_start = $meeting_data['meeting_start'];
                $meeting_date = $meeting_data['meeting_date'];
                $is_started = $meeting_data['is_started'];
                if( !$is_started ) {
                    $content = self::countdown( $meeting_date );
                }
                else {
                    $content = self::zoom_content( $post_id, $meeting_start );
                }
            }
        }
        return $content;
    }


    public static function meeting_time_data($post_id){

        if(empty($post_id)) return false;
        $r = array();
        $post_id = intval( $post_id );
        $start_date = get_post_meta( $post_id, 'stm_date', true );
        $start_time = get_post_meta( $post_id, 'stm_time', true );
        $timezone = get_post_meta( $post_id, 'stm_timezone', true );
        $meeting_start = strtotime( 'tomorrow', ( intval( $start_date ) / 1000 ) );
        if( !empty( $start_time ) ) {
            $time = explode( ':', $start_time );
            if( is_array( $time ) and count( $time ) === 2 ) {
                $meeting_start = strtotime( "+{$time[0]} hours +{$time[1]} minutes", $meeting_start );
            }
        }
        $meeting_start = date( 'Y-m-d H:i:s', $meeting_start );
        if(empty($timezone)) {
            $timezone = 'UTC';
        }
        $meeting_date = new DateTime( $meeting_start, new DateTimeZone( $timezone ) );
        $meeting_date = $meeting_date->format( 'U' );
        $is_started = ( $meeting_date > time() ) ? false : true;
        $r['meeting_start'] = $meeting_start;
        $r['meeting_date'] = $meeting_date;
        $r['is_started'] = $is_started;

        return $r;
    }


    public static function countdown( $time = '' )
    {
        if( !empty( $time ) ) {
            return '<div class="stm_zooom_countdown" data-timer="' . esc_attr( $time ) . '"></div>';
        }
    }

    public static function zoom_content( $post_id, $meeting_start )
    {
        if( !empty( $post_id ) ) {

            $zoom_data = get_post_meta( $post_id, 'stm_zoom_data', true );
            if( !empty( $zoom_data ) && !empty( $zoom_data[ 'id' ] ) ) {
                $settings = get_option('stm_zoom_settings', array());
                $meeting_id = sanitize_text_field( $zoom_data[ 'id' ] );
                $title = get_the_title( $post_id );
                $agenda = get_post_meta( $post_id, 'stm_agenda', true );
                $password = get_post_meta( $post_id, 'stm_password', true );
                $api_key = $settings[ 'api_key' ];
                $api_secret = $settings[ 'api_secret' ];
                $js_data = array(
                    'api_key' => $api_key,
                    'api_secret' => $api_secret,
                    'password' => $password,
                    'meeting_id' => $zoom_data[ 'id' ],
                    'username' => apply_filters( 'stm_zoom_meeting_username', get_bloginfo() ),
                );
                if(!empty($api_key) && !empty($api_secret) && empty($_GET['action'])){

                    wp_enqueue_script('zoom-react', 'https://source.zoom.us/1.7.6/lib/vendor/react.min.js', array(), '1.7.6', true);
                    wp_enqueue_script('zoom-react-dom', 'https://source.zoom.us/1.7.6/lib/vendor/react-dom.min.js', array(), '1.7.6', true);
                    wp_enqueue_script('zoom-redux', 'https://source.zoom.us/1.7.6/lib/vendor/redux.min.js', array(), '1.7.4', true);
                    wp_enqueue_script('zoom-redux-thunk', 'https://source.zoom.us/1.7.6/lib/vendor/redux-thunk.min.js', array(), '1.7.6', true);
                    wp_enqueue_script('zoom-lodash', 'https://source.zoom.us/1.7.6/lib/vendor/lodash.min.js', array(), '1.7.6', false);
                    wp_enqueue_script('zoom-meeting', STM_ZOOM_URL . '/assets/js/frontend/zoom/zoom-meeting-1.7.6.min.js', array(), '1.7.6', true);
                    wp_enqueue_script('zoom-tools', STM_ZOOM_URL . '/assets/js/frontend/zoom/tool.js', array(), '1.7.4', true);
                    wp_enqueue_script('zoom-index', STM_ZOOM_URL . '/assets/js/frontend/zoom/index.js', array(), '1.7.4', true);

                    $js_data = array(
                      'api_key' => $api_key,
                      'api_secret' => $api_secret,
                      'password' => $password,
                      'meeting_id' => $zoom_data[ 'id' ],
                      'home_url' => home_url('/'),
                      'username' => apply_filters('stm_zoom_meeting_username', get_bloginfo()),
                    );
                    wp_add_inline_script('zoom-index', 'var stm_zoom_settings = '. json_encode($js_data), 'before' );
                    wp_add_inline_script('zoom-meeting', 'var $ = jQuery', 'before' );
                }

                ob_start();
                ?>
                <div class="stm_zoom_content">
                    <h2><?php echo esc_html( $title ); ?></h2>
                    <?php if( !empty( $meeting_start ) ): ?>
                        <div class="date">
                            <span><?php esc_html_e( 'Meeting started at', 'eroom-zoom-meetings-webinar' ) ?> </span>
                            <b><?php echo esc_html( $meeting_start ); ?></b>
                        </div>
                    <?php endif; ?>
                    <?php if( !empty( $agenda ) ): ?>
                        <div class="agenda">
                            <?php echo wp_kses_post( $agenda ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if( !empty( $password ) ): ?>
                        <div class="password">
                            <span><?php esc_html_e( 'Password: ', 'eroom-zoom-meetings-webinar' ); ?></span>
                            <span class="value"><?php echo esc_html( $password ); ?></span>
                        </div>
                    <?php endif; ?>
                    <div id="zmmtg-root"></div>
                    <div id="aria-notify-area"></div>
                    <a href="#" class="btn stm-join-btn join_in_menu">
                        <?php esc_html_e( 'Join meeting in browser', 'eroom-zoom-meetings-webinar' ); ?>
                    </a>
                    <a href="https://zoom.us/j/<?php echo esc_attr( $meeting_id ); ?>" class="btn stm-join-btn"
                       target="_blank">
                        <?php esc_html_e( 'Join meeting in zoom app', 'eroom-zoom-meetings-webinar' ); ?>
                    </a>
                </div>
                <?php
                $content = ob_get_clean();
                return $content;
            }
        }
    }


    static function admin_submenu_pages()
    {
        $pages = array(
            array(
                'slug' => 'stm_zoom_users',
                'menu_slug' => 'stm_zoom_users',
                'label' => esc_html__('Users', 'eroom-zoom-meetings-webinar')
            ),
            array(
                'slug' => 'stm_zoom_add_user',
                'menu_slug' => 'stm_zoom_add_user',
                'label' => esc_html__('Add user', 'eroom-zoom-meetings-webinar')
            ),
            array(
                'slug' => 'stm_zoom_reports',
                'menu_slug' => 'stm_zoom_reports',
                'label' => esc_html__('Reports', 'eroom-zoom-meetings-webinar')
            ),
            array(
                'slug' => 'stm_zoom_assign_host_id',
                'menu_slug' => 'stm_zoom_assign_host_id',
                'label' => esc_html__('Assign host id', 'eroom-zoom-meetings-webinar')
            ),

        );
        foreach( $pages as $page ) {
            add_submenu_page(
                'stm_zoom',
                $page[ 'label' ],
                $page[ 'label' ],
                'manage_options',
                $page[ 'menu_slug' ],
                'admin_pages'
            );
        }
        remove_submenu_page( 'stm_zoom', 'stm_zoom' );
    }

    static function admin_settings_page()
    {
        add_filter( 'wpcfto_options_page_setup', function( $setup ) {
            $fields = array(
                'tab_1' => array(
                    'name' => esc_html__( 'Main settings', 'eroom-zoom-meetings-webinar' ),
                    'fields' => array(
                        'api_key' => array(
                            'type' => 'text',
                            'label' => esc_html__( 'API key', 'eroom-zoom-meetings-webinar' ),
                            'value' => '',
                            'description' => __( 'Please follow this <a href="https://support.stylemixthemes.com/manuals/eroom/#how-to-obtain-apis" target="_blank">guide</a> to generate API values from your Zoom account', 'eroom-zoom-meetings-webinar' )
                        ),
                        'api_secret' => array(
                            'type' => 'text',
                            'label' => esc_html__( 'API Secret Key', 'eroom-zoom-meetings-webinar' ),
                            'value' => '',
                        ),
                    )
                ),
            );
            $setup[] = array(
                'option_name' => 'stm_zoom_settings',
                'page' => array(
                    'page_title' => 'Zoom Settings',
                    'menu_title' => 'Zoom Settings',
                    'menu_slug' => 'stm_zoom_settings',
                    'icon' => 'dashicons-video-alt2',
                    'position' => 40,
                    'parent_slug' => 'stm_zoom'
                ),
                'fields' => apply_filters('stm_zoom_settings_fields', $fields)
            );

            return $setup;
        }, 200 );
    }

    static function register_post_type()
    {
        $args = array(
            'labels' => array(
                'name' => esc_html__( 'Zoom meetings', 'eroom-zoom-meetings-webinar' ),
                'singular_name' => esc_html__( 'Zoom meeting', 'eroom-zoom-meetings-webinar' ),
                'add_new' => esc_html__( 'Add new', 'eroom-zoom-meetings-webinar' ),
                'add_new_item' => esc_html__( 'Add new', 'eroom-zoom-meetings-webinar' ),
                'edit_item' => esc_html__( 'Edit meeting', 'eroom-zoom-meetings-webinar' ),
                'new_item' => esc_html__( 'New meeting', 'eroom-zoom-meetings-webinar' ),
                'view_item' => esc_html__( 'View meeting', 'eroom-zoom-meetings-webinar' ),
                'search_items' => esc_html__( 'Search meeting', 'eroom-zoom-meetings-webinar' ),
                'not_found' => esc_html__( 'Not found', 'eroom-zoom-meetings-webinar' ),
                'not_found_in_trash' => esc_html__( 'Not found', 'eroom-zoom-meetings-webinar' ),
                'menu_name' => esc_html__( 'Zoom meetings', 'eroom-zoom-meetings-webinar' ),
            ),
            'public' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => true,
            'show_ui' => true,
            'show_in_menu' => 'stm_zoom',
            'capability_type' => 'post',
            'supports' => array( 'title', 'author' ),
        );

        register_post_type( 'stm-zoom', $args );
    }

    static function metaboxes()
    {
        add_filter( 'stm_wpcfto_boxes', function( $boxes ) {

            $boxes[ 'stm_zoom_meeting' ] = array(
                'post_type' => array( 'post', 'stm-zoom' ),
                'label' => esc_html__( 'Post settings', 'eroom-zoom-meetings-webinar' ),
            );

            return $boxes;
        } );

        add_filter( 'stm_wpcfto_fields', function( $fields ) {

            $fields[ 'stm_zoom_meeting' ] = array(

                'tab_1' => array(
                    'name' => esc_html__( 'Meeting settings', 'eroom-zoom-meetings-webinar' ),
                    'fields' => array(
                        'stm_agenda' => array(
                            'type' => 'textarea',
                            'label' => esc_html__( 'Meeting agenda', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_host' => array(
                            'type' => 'select',
                            'label' => esc_html__( 'Meeting host', 'eroom-zoom-meetings-webinar' ),
                            'options' => self::get_users_options()
                        ),
                        'stm_date' => array(
                            'type' => 'date',
                            'label' => esc_html__( 'Meeting date', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_time' => array(
                            'type' => 'time',
                            'label' => esc_html__( 'Meeting time', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_timezone' => array(
                            'type' => 'select',
                            'label' => esc_html__( 'Meeting timezone', 'eroom-zoom-meetings-webinar' ),
                            'options' => stm_zoom_get_timezone_options()
                        ),
                        'stm_duration' => array(
                            'type' => 'number',
                            'label' => esc_html__( 'Meeting duration (in min)', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_password' => array(
                            'type' => 'text',
                            'label' => esc_html__( 'Meeting password', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_join_before_host' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Join Before Host', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_host_join_start' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Host join start', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_start_after_participants' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Start After Participants', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_mute_participants' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Mute Participants upon entry', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_enforce_login' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Enforce Login', 'eroom-zoom-meetings-webinar' ),
                        ),
                        'stm_alternative_hosts' => array(
                            'type' => 'autocomplete',
                            'label' => esc_html__( 'Alternative hosts', 'eroom-zoom-meetings-webinar' ),
                            'post_type' => array()
                        ),
                    )
                ),

            );

            return $fields;
        } );
    }

    static public function stm_zoom_get_users()
    {
        $users = get_transient( 'stm_zoom_users' );
        $settings = get_option( 'stm_zoom_settings', array() );

        if( empty( $users ) ) {
            $api_key = !empty($settings[ 'api_key' ]) ? $settings[ 'api_key' ] : '';
            $api_secret = !empty($settings[ 'api_secret' ]) ? $settings[ 'api_secret' ] : '';
            if( !empty( $api_key ) && !empty( $api_secret ) ) {
                $users_data = new \Zoom\Endpoint\Users( $api_key, $api_secret );
                $users_list = $users_data->list();
                if( !empty( $users_list ) && !empty( $users_list[ 'users' ] ) ) {
                    $users = $users_list[ 'users' ];
                    set_transient( 'stm_zoom_users', $users, 36000 );
                }
            }
            else {
                $users = array();
            }
        }
        return $users;
    }

    public static function get_users_options()
    {
        $users = self::stm_zoom_get_users();
        if( !empty( $users ) ) {
            foreach( $users as $user ) {
                $first_name = $user[ 'first_name' ];
                $last_name = $user[ 'last_name' ];
                $email = $user[ 'email' ];
                $id = $user[ 'id' ];
                $user_list[ $id ] = $first_name . ' ' . $last_name . ' (' . $email . ')';
            }
        }
        else {
            return array();
        }
        return $user_list;
    }

    static function get_autocomplete_users_options()
    {
        $users = self::get_users_options();
        $r = array();
        foreach( $users as $id => $user ) {
            $r[] = array(
                'id' => $id,
                'title' => $user,
                'post_type' => ''
            );
        }
        return $r;
    }

    public function update_meeting( $post_id )
    {
        $post_type = !empty( $_POST[ 'post_type' ] ) ? sanitize_text_field( $_POST[ 'post_type' ] ) : '';

        if( empty( $post_type ) ) {
            $post_type = get_post_type( $post_id );
        }
        if( $post_type === 'stm-zoom' ) {
            $settings = get_option( 'stm_zoom_settings', array() );
            $api_key = $settings[ 'api_key' ];
            $api_secret = $settings[ 'api_secret' ];

            $host_id = !empty( $_POST[ 'stm_host' ] ) ? sanitize_text_field( $_POST[ 'stm_host' ] ) : '';
            $title = !empty( $_POST[ 'post_title' ] ) ? sanitize_text_field( $_POST[ 'post_title' ] ) : '';
            $agenda = !empty( $_POST[ 'stm_agenda' ] ) ? sanitize_text_field( $_POST[ 'stm_agenda' ] ) : '';
            $start_date = !empty( $_POST[ 'stm_date' ] ) ? intval( $_POST[ 'stm_date' ] ) : '';
            $start_time = !empty( $_POST[ 'stm_time' ] ) ? sanitize_text_field( $_POST[ 'stm_time' ] ) : '';
            $timezone = !empty( $_POST[ 'stm_timezone' ] ) ? sanitize_text_field( $_POST[ 'stm_timezone' ] ) : '';
            $duration = !empty( $_POST[ 'stm_duration' ] ) ? intval( $_POST[ 'stm_duration' ] ) : 60;
            $password = !empty( $_POST[ 'stm_password' ] ) ? sanitize_text_field( $_POST[ 'stm_password' ] ) : '';
            $join_before_host = !empty( $_POST[ 'stm_join_before_host' ] ) ? true : false;
            $host_join_start = !empty( $_POST[ 'stm_host_join_start' ] ) ? true : false;
            $start_after_participantst = !empty( $_POST[ 'stm_start_after_participants' ] ) ? true : false;
            $mute_participants = !empty( $_POST[ 'stm_mute_participants' ] ) ? true : false;
            $enforce_login = !empty( $_POST[ 'stm_enforce_login' ] ) ? true : false;

            $alternative_hosts = '';
            if( !empty( $_POST[ 'stm_alternative_hosts' ] ) ) {
                $alternative_hosts = sanitize_text_field($_POST[ 'stm_alternative_hosts' ]);
            }
            if( is_array( $alternative_hosts ) && !empty( $alternative_hosts ) ) {
                $alternative_hosts = implode( ',', $alternative_hosts );
            }

            $meeting_start = strtotime( 'tomorrow', ( intval( $start_date ) / 1000 ) );
            if( !empty( $start_time ) ) {
                $time = explode( ':', $start_time );
                if( is_array( $time ) and count( $time ) === 2 ) {
                    $meeting_start = strtotime( "+{$time[0]} hours +{$time[1]} minutes", $meeting_start );
                }
            }
            $meeting_start = date( 'Y-m-d\TH:i:s', $meeting_start );

            $data = array(
                'topic' => $title,
                'type' => 2,
                'start_time' => $meeting_start,
                'agenda' => $agenda,
                'timezone' => $timezone,
                'duration' => $duration,
                'password' => $password,
                'settings' => array(
                    'join_before_host' => $join_before_host,
                    'host_video' => $host_join_start,
                    'participant_video' => $start_after_participantst,
                    'mute_upon_entry' => $mute_participants,
                    'enforce_login' => $enforce_login,
                    'alternative_hosts' => $alternative_hosts,
                )
            );
            $meeting_data = get_post_meta( $post_id, 'stm_zoom_data', true );

            if( empty( $meeting_data[ 'id' ] ) ) {

                if( !empty( $api_key ) && !empty( $api_secret ) && !empty( $host_id ) ) {
                    remove_action( 'save_post', array( $this, 'update_meeting' ), 10 );

                    $zoom = new \Zoom\Endpoint\Meetings( $api_key, $api_secret );

                    $new_meeting = $zoom->create( $host_id, $data );

                    update_post_meta( $post_id, 'stm_zoom_data', $new_meeting );

                    do_action('stm_zoom_after_create_meeting', $post_id);
                }
            }
            else {
                $meeting_id = $meeting_data[ 'id' ];
                remove_action( 'save_post', array( $this, 'update_meeting' ), 10 );

                $zoom = new \Zoom\Endpoint\Meetings( $api_key, $api_secret );

                $update_meeting = $zoom->update( $meeting_id, $data );

                do_action('stm_zoom_after_update_meeting', $post_id);

            }
        }
    }
}