<?php
$courses = get_post_meta(get_the_ID(), STM_LMS_My_Bundle::bundle_courses_key(), true);
$price = get_post_meta(get_the_ID(), STM_LMS_My_Bundle::bundle_price_key(), true);

if (!empty($courses)): ?>

    <div class="stm_lms_single_bundle__courses_wrapper">

        <h3><?php esc_html_e('Courses in this bundle:', 'masterstudy-lms-learning-management-system-pro'); ?></h3>

        <div class="stm_lms_single_bundle__courses">

            <?php foreach ($courses as $course_id): ?>

                <a href="<?php echo esc_url(get_the_permalink($course_id)); ?>" class="stm_lms_single_bundle__courses_course">

                    <div class="stm_lms_single_bundle__courses_course__inner">

                        <div class="stm_lms_single_bundle__courses_course__image">
                            <?php echo stm_get_VC_img(get_post_thumbnail_id($course_id), '85x50'); ?>
                        </div>

                        <div class="stm_lms_single_bundle__courses_course__data heading_font">

                            <div class="stm_lms_single_bundle__courses_course__title">
                                <?php echo get_the_title($course_id); ?>
                            </div>

                            <?php if (!empty($price)): ?>
                                <div class="stm_lms_single_bundle__courses_course__price">
                                    <?php echo STM_LMS_Helpers::display_price(STM_LMS_Course::get_course_price($course_id)); ?>
                                </div>
                            <?php endif; ?>

                        </div>

                    </div>

                </a>

            <?php endforeach; ?>

        </div>

    </div>

<?php endif;