(function ($) {


    $(document).ready(function () {

        new Vue({
            el: '#stm_lms_my_bundle',
            data: function () {
                return {
                    courses: stm_lms_my_bundle_courses['list']['posts'],
                    bundle_courses: [],
                    bundle_name: '',
                    bundle_description: '',
                    bundle_price: '',
                    bundle_image_id: '',

                    bundle_limit: stm_lms_my_bundle_courses['bundle_limit'],

                    bundle_upload_image: '',

                    select_course_search: '',
                    select_course_open: false,

                    status: '',
                    message: '',
                    translations: stm_lms_my_bundle_courses['translations'],
                    loading: false,
                }
            },
            mounted: function () {
                var vm = this;
                var data = stm_lms_my_bundle['data'];
                if (typeof data !== 'undefined') {
                    if (typeof data.post_title !== 'undefined') vm.$set(vm, 'bundle_name', data.post_title);
                    if (typeof data.post_content !== 'undefined') vm.$set(vm, 'bundle_description', data.post_content);
                    if (typeof data.bundle_price !== 'undefined') vm.$set(vm, 'bundle_price', data.bundle_price);
                    if (typeof data.bundle_courses !== 'undefined') vm.$set(vm, 'bundle_courses', data.bundle_courses);
                    if (typeof data.bundle_image_id !== 'undefined') vm.$set(vm, 'bundle_image_id', data.bundle_image_id);
                }

                Vue.nextTick(function () {

                    $(window).load(function () {
                        if (typeof tinyMCE !== 'undefined') {
                            var editor = tinyMCE.get(stm_lms_my_bundle_courses['editor_id']);

                            if (editor !== null) {
                                vm.$set(vm, 'bundle_description', editor.getContent());

                                editor.on('keyup', function (e) {
                                    vm.$set(vm, 'bundle_description', editor.getContent());
                                });

                            } else {

                                var $textarea = $('#' + stm_lms_my_bundle_courses['editor_id']);

                                vm.$set(vm, 'bundle_description', $textarea.val());

                                $textarea.on('change keyup paste', function () {
                                    vm.$set(vm, 'bundle_description', $textarea.val());
                                });

                            }

                        }
                    });

                })
            },
            methods: {
                alreadyAdded(course) {
                    var vm = this;
                    var inBundle = false;
                    vm.bundle_courses.forEach(function (value) {
                        if (value.id === course.id) inBundle = true;
                    });
                    return inBundle;
                },
                addCourseInBundle(course) {
                    if (parseFloat(this.bundle_limit) <= this.bundle_courses.length) {
                        alert('You reached maximum courses in bundle.');
                        return false;
                    }
                    this.bundle_courses.push(course);
                },
                saveBundle() {
                    var vm = this;
                    var name = vm.bundle_name;
                    var courses = vm.bundleCoursesIds;
                    var price = vm.bundle_price;
                    var description = vm.bundle_description;

                    vm.$set(vm, 'status', '');
                    vm.$set(vm, 'message', '');


                    if (!name) {
                        vm.$set(vm, 'status', 'error');
                        vm.$set(vm, 'message', vm.translations['empty_name']);
                        return true;
                    }

                    if (!courses.length) {
                        vm.$set(vm, 'status', 'error');
                        vm.$set(vm, 'message', vm.translations['empty_courses']);
                        return true;
                    }

                    if (!price) {
                        vm.$set(vm, 'status', 'error');
                        vm.$set(vm, 'message', vm.translations['empty_price']);
                        return true;
                    }

                    var formData = new FormData();
                    formData.append('id', stm_lms_my_bundle_courses['bundle_id']);
                    formData.append('name', name);
                    formData.append('courses', courses);
                    formData.append('price', price);
                    formData.append('description', description);
                    formData.append('file', vm.bundle_upload_image);
                    vm.loading = true;

                    vm.$http.post(stm_lms_ajaxurl + '?action=stm_lms_save_bundle', formData).then(function (res) {
                        res = res.body;

                        vm.loading = false;

                        vm.$set(vm, 'status', res.status);
                        vm.$set(vm, 'message', res.message);

                        if (typeof res.url !== 'undefined') window.location.href = res.url;
                    });

                },
                previewFiles() {
                    var vm = this;
                    if (typeof this.$refs.bundleImage.files[0] !== 'undefined') {
                        vm.$set(vm, 'bundle_upload_image', this.$refs.bundleImage.files[0]);
                    }
                }
            },
            computed: {
                filteredList() {
                    return this.courses.filter(course => {
                        return course.title.toLowerCase().includes(this.select_course_search.toLowerCase())
                    })
                },
                totalPrice() {
                    var vm = this;
                    var price = 0;
                    vm.bundle_courses.forEach(function (value) {
                        if (value['simple_price'] !== '') {
                            price += parseFloat(value['simple_price']);
                        }
                    });
                    return stm_lms_price_format(price);
                },
                bundleCoursesIds() {
                    var vm = this;
                    var ids = [];
                    vm.bundle_courses.forEach(function (value) {
                        ids.push(value.id);
                    });
                    return ids;
                }
            }
        });
    });

})(jQuery);